<?php
// @codingStandardsIgnoreStart
if ( ! defined( 'ABSPATH' ) ) die( 'Direct access forbidden.' );


/* GENERAL
***************************************************/
{
	/*! set content width
	------------------------------------------------->*/
	if ( ! isset( $content_width ) ) $content_width = 1170;

	/*! label for kirki
	------------------------------------------------->*/
	if( ! function_exists( 'goto_label' ) ):
		function goto_label( $data = '' ){
			$output  = '<span style="padding: 7px 10px; background-color: #0073aa; color: #fff; display: block">' .  $data . '</span>';
			return $output;
		}
	endif;

	/*! SET DEFAULT FONT-FAMILY FOR ELEMENTS
	------------------------------------------------->*/
	add_action( 'wp_enqueue_scripts', 'goto_typo_default' );
	function goto_typo_default() {
		if( class_exists( 'Kirki' ) ) return;

		$default = get_theme_mod( 'typo_body', array( 'font-family' => 'Open Sans' ) );
		echo '<style type="text/css">input, select, textarea, button{font-family: ' . $default['font-family'] . ', sans-serif!important}</style>';
	}

	/*! img alt
	------------------------------------------------->*/
	if( ! function_exists( 'goto_img_alt' ) ):
		function goto_img_alt( $id = null, $alt = '' ) {
			$data = get_post_meta( $id, '_wp_attachment_image_alt', true );
			$img_alt = ! empty( $data ) ? $data : $alt;

			return $img_alt;
		}
	endif;

	/*! edit location
	------------------------------------------------->*/
	if( ! function_exists( 'goto_edit_location' ) ):
		function goto_edit_location( $id = '' ) {
			$option = $id . '_edit_location';
			if( is_customize_preview() ):
				echo '<div id="' . esc_attr( $id ) . '-edit-location">';
					if ( class_exists( 'Kirki' ) )
						echo Kirki::get_option ( $option );
				echo '</div>';
			endif;
		}
	endif;

	/*! defined header menu layout slug, e.g: `layout-1`
	------------------------------------------------->*/
	if( ! function_exists( 'goto_defined_header_menu_slug' ) ):
		function goto_defined_header_menu_slug() {
			/*CUSTOMIZER*/
			$c_menu_layout = get_theme_mod( 'header_layout_cfg', 'layout-1' );

			/*BLOG PAGE*/
			if( goto_blog() ){
				$c_menu_layout = get_theme_mod( 'blog_header_layout_cfg', 'layout-1' );
			}

			/*PAGE OPTIONS*/
			$p_menu_layout = goto_page_opt( get_queried_object_id(), 'page_menu_layout' );
			if( isset( $p_menu_layout ) && 'default' != $p_menu_layout ) {
				return $p_menu_layout;
			}
			
			return $c_menu_layout;
		}
	endif;

	/*! logo image
	------------------------------------------------->*/
	if( ! function_exists( 'goto_logo_image' ) ):
		function goto_logo_image(){
			$pid = get_queried_object_id();
			$p_lg = function_exists( 'fw_get_db_post_option' ) ? fw_get_db_post_option( $pid, 'p_lg' ) : '';
			
			/*general logo*/
			$general_logo = get_theme_mod( 'custom_logo' );

			/*logo src*/
			$logo_src = ! empty( $general_logo ) ? wp_get_attachment_image_src( $general_logo, 'full' )[0] : get_template_directory_uri() . '/images/logo.svg';

			/*custom logo for menu layout 2*/
			if( 'layout-2' == goto_defined_header_menu_slug() && '' != get_theme_mod( 'hd2_logo' ) ){
				$logo_src = get_theme_mod( 'hd2_logo' );
			}

			$tag = 'figure';
			$child_tag = 'figcaption';

			if( is_front_page() ) {
				$tag = 'h1';
				$child_tag = 'span';
			}        
			
			?>
				<<?php echo esc_attr( $tag ) . ' '; ?> class="theme-logo" itemscope itemtype="http://schema.org/Organization">
					<a class="logo" href="<?php echo esc_url( home_url( '/' ) ); ?>" itemprop="url">
						<img
							src="<?php echo esc_url( $logo_src ); ?>"
							alt="<?php esc_attr_e( 'Logo image', 'goto' ); ?>"
							itemprop="logo" >
						<?php
							$hd2_layout = get_theme_mod( 'header_layout_cfg', 'layout-1' );
							$blog_layout = get_theme_mod( 'blog_header_layout_cfg', 'layout-1' );

							if( goto_blog() ){
								$hd2_layout = $blog_layout;
							}

							$page_menu_layout = goto_page_opt( $pid, 'page_menu_layout' );
							if( isset( $page_menu_layout ) && 'default' != $page_menu_layout ){
								$hd2_layout = $page_menu_layout;
							}

							if( 'layout-2' == $hd2_layout && ! empty( get_theme_mod( 'hd2_logo_mobile' ) ) ):
							?>
								<img
									src="<?php echo esc_url( get_theme_mod( 'hd2_logo_mobile' ) ); ?>"
									alt="<?php esc_attr_e( 'Logo image', 'goto' ); ?>"
									class="custom-logo-mobile"
									itemprop="logo" >
							<?php endif; ?>
					</a>
					<<?php echo esc_attr( $child_tag ); ?> class="screen-reader-text"><?php echo esc_attr( bloginfo( 'name' ) ); ?></<?php echo esc_attr( $child_tag ); ?>>
				</<?php echo esc_attr( $tag ); ?>>
			<?php
		}
	endif;

	/*! schema markup `support for SEO`
	------------------------------------------------->*/
	if( ! function_exists( 'goto_schema_markup' )):
		function goto_schema_markup( $type ) {
		
			if ( empty( $type ) ) return;
			
			$attributes = '';
			$attr = array();
			
			switch ( $type ) {
				case 'head':
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'https://schema.org/WebSite';
					break;

				case 'body':
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'https://schema.org/WebPage';
					break;

				case 'header':
					$attr['role']      = 'banner';
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'https://schema.org/WPHeader';
					break;

				case 'nav':
					$attr['role']      = 'navigation';
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'https://schema.org/SiteNavigationElement';
					break;

				case 'breadcrumb':
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'https://schema.org/BreadcrumbList';
					break;

				case 'title':
					$attr['itemprop'] = 'headline';
					break;

				case 'sidebar':
					$attr['role']      = 'complementary';
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'https://schema.org/WPSideBar';
					break;

				case 'footer':
					$attr['role']      = 'contentinfo';
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'https://schema.org/WPFooter';
					break;

				case 'main':
					$attr['itemprop'] = 'mainContentOfPage';
					if ( is_search() ) {
						$attr['itemtype'] = 'https://schema.org/SearchResultsPage';
					}                
					break;

				case 'article':
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'https://schema.org/Article';
					break;

				case 'blog':
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'https://schema.org/Blog';
					break;

				case 'blog_list':
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'https://schema.org/BlogPosting';
					break;

				case 'creative_work':
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'https://schema.org/CreativeWork';
					break;

				case 'author':
					$attr['itemprop']  = 'author';
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'https://schema.org/Person';
					break;

				case 'person':
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'https://schema.org/Person';
					break;

				case 'comment':
					$attr['itemprop']  = 'comment';
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'https://schema.org/UserComments';
					break;

				case 'comment_author':
					$attr['itemprop']  = 'creator';
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'https://schema.org/Person';
					break;

				case 'comment_author_link':
					$attr['itemprop']  = 'creator';
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'https://schema.org/Person';
					$attr['rel']       = 'external nofollow';
					break;

				case 'comment_time':
					$attr['itemprop']  = 'commentTime';
					$attr['itemscope'] = 'itemscope';
					$attr['datetime']  = get_the_time( 'c' );
					break;

				case 'comment_text':
					$attr['itemprop'] = 'commentText';
					break;

				case 'author_box':
					$attr['itemprop']  = 'author';
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'https://schema.org/Person';
					break;

				case 'video':
					$attr['itemprop'] = 'video';
					$attr['itemtype'] = 'https://schema.org/VideoObject';
					break;

				case 'audio':
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'https://schema.org/AudioObject';
					break;

				case 'image':
					$attr['itemscope'] = 'itemscope';
					$attr['itemprop']  = 'image';
					$attr['itemtype']  = 'http://schema.org/ImageObject';
					break;

				case 'organization':
					$attr['itemprop']  = 'organization';
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'http://schema.org/Organization';
					break;

				case 'publisher':
					$attr['itemprop']  = 'publisher';
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'http://schema.org/Organization';
					break;

				case 'logo':
					$attr['itemprop']  = 'logo';
					$attr['itemscope'] = 'itemscope';
					$attr['itemtype']  = 'http://schema.org/Organization ';
					break;

				case 'name':
					$attr['itemprop'] = 'name';
					break;

				case 'url':
					$attr['itemprop'] = 'url';
					break;

				case 'email':
					$attr['itemprop'] = 'email';
					break;

				case 'job':
					$attr['itemprop'] = 'jobTitle';
					break;

				case 'post_time':                
					$attr['itemprop'] = 'datePublished';
					$attr['datetime'] = get_the_time( 'c', $args['id'] );
					break;

				case 'post_title':
					$attr['itemprop'] = 'headline';
					break;

				case 'post_content':
					$attr['itemprop'] = 'text';
					break;
			}
			
			foreach ( $attr as $key => $value ) {
				$attributes .= $key . '="' . $value . '" ';
			}
			
			echo wp_kses_post( $attributes );
		}
	endif;

	/*! svg support
	------------------------------------------------->*/
	add_action( 'upload_mimes', 'goto_svg_uploads' );
	function goto_svg_uploads( $type ){
		$new_type        = array();
		$new_type['svg'] = 'image/svg+xml';
		$type            = array_merge($type, $new_type );

		return $type;
	}

	/*! wp_link_pages
	------------------------------------------------->*/
	if( ! function_exists( 'goto_wp_link_pages' ) ):
		function goto_wp_link_pages(){
			$args = array(
				'before'      => '<div class="theme-page-links">',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
			);
			return wp_link_pages($args);
		}
	endif;

	/*! remove tag-cloud inline css
	------------------------------------------------->*/
	add_filter( 'wp_generate_tag_cloud', 'goto_tag_cloud', 10, 1 );
	function goto_tag_cloud( $string ){
		return preg_replace( '/ style=("|\')(.*?)("|\')/', '', $string );
	}

	/* THEME SEARCH FORM
	***************************************************/
	if( ! function_exists( 'goto_dialog_search_form' ) ):
		function goto_dialog_search_form(){
			$action = home_url( '/' );
			$name   = 's';
			if( true == get_theme_mod( 'search', false ) ){
				$action = goto_template_name();
				$name   = 'keywords';
			}
		?>
			<form id="theme-search-form" class="dialog" method="get" action="<?php echo esc_url( $action ); ?>">
				<div class="dialog-content container">
					<label class="sr-only"><?php esc_html_e( 'Search for:', 'goto' ) ?></label>
					<input type="text" placeholder="<?php esc_attr_e( 'Search...', 'goto' ) ?>" name="<?php echo esc_attr( $name ); ?>" required />
					<span><?php esc_html_e( 'Hit Enter to search or Esc key to close', 'goto' ); ?></span>
				</div>
				<span id="theme-search-form-overlay" class="dialog-overlay"></span>
			</form>
		<?php
		}
	endif;

	/* DETECT IE BROWSER
	***************************************************/
	if( ! function_exists( 'goto_ie' ) ):
		function goto_ie(){
			global $is_winIE;
			if( $is_winIE ){
				return true;
			}
			return false;
		}
	endif;

	/* PRELOADER
	***************************************************/
	if( ! function_exists( 'goto_preloader' ) ):
		function goto_preloader(){
			if( false == get_theme_mod( 'loading', false ) ) return;
			?>
				<div id="preloader" class="loading"></div>
			<?php
		}
	endif;
}


/* BLOG
***************************************************/
{
	/*! detect blog page
	------------------------------------------------->*/
	if( ! function_exists( 'goto_blog' ) ):
		function goto_blog() {
			global $post;
			$post_type = get_post_type( $post );
			return ( 'post' == $post_type && ( is_archive() || is_author() || is_category() || is_home() || is_single() || is_tag() ) ) ? true : false;
		}
	endif;

	/*! theme tags
	------------------------------------------------->*/
	if( ! function_exists( 'goto_blog_tags' ) ):
		function goto_blog_tags(){
			if( has_tag() ):
			?>
				<div class="blog-tagcloud" itemprop="keywords"><?php echo the_tags( $before = '<span>' . esc_html__( 'Tags: ', 'goto' ) . '</span>', $sep = ', ', $after = '' ); ?></div>
			<?php
			endif;
		}
	endif;

	/*! blog pagination
	------------------------------------------------->*/
	if ( ! function_exists( 'goto_paging' ) ):
		function goto_paging( $wp_query = null, $paged = null ) {

			if ( ! $wp_query ) {
				$wp_query = $GLOBALS['wp_query'];
			}

			/*Don't print empty markup if there's only one page.*/

			if ( $wp_query->max_num_pages < 2 ) {
				return;
			}

			if ( ! $paged ) {
				$paged = is_front_page() ? get_query_var( 'page' ) : get_query_var( 'paged' );
				$paged = $paged ? intval( $paged ) : 1;
			}

			$pagenum_link = html_entity_decode( get_pagenum_link() );
			$query_args   = array();
			$url_parts    = explode( '?', $pagenum_link );

			if ( isset( $url_parts[1] ) ) {
				wp_parse_str( $url_parts[1], $query_args );
			}

			$pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
			$pagenum_link = trailingslashit( $pagenum_link ) . '%_%';

			$format = $GLOBALS['wp_rewrite']->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
			$format .= $GLOBALS['wp_rewrite']->using_permalinks() ? user_trailingslashit( 'page/%#%', 'paged' ) : '?paged=%#%';

			/*Set up paginated links.*/
			$links = paginate_links( array(
				'base'      => $pagenum_link,
				'format'    => $format,
				'total'     => $wp_query->max_num_pages,
				'current'   => $paged,
				'mid_size'  => 1,
				'add_args'  => array_map( 'urlencode', $query_args ),
				'prev_text' => '',
				'next_text' => '',
				'type'      => 'list'
			) );
			
			if ( $links ):
			?>
				<nav class="ht-pagination">
					<span class="screen-reader-text"><?php esc_html_e( 'Posts pagination', 'goto' ); ?></span>
					<?php echo wp_kses_post( $links ); ?>
				</nav>
			<?php
			endif;
		}
	endif;

	/*! blog categories
	------------------------------------------------->*/
	if( ! function_exists( 'goto_blog_categories' ) ):
		function goto_blog_categories(){
			return get_the_term_list( get_the_ID(), 'category', null, ', ', null );
		}
	endif;

	/*! change output comment list
	------------------------------------------------->*/
	if( ! function_exists( 'goto_comment_list' ) ):
		function goto_comment_list( $comment, $args, $depth ){
			$GLOBALS['comment'] = $comment;
			switch ( $comment->comment_type ):
				case 'pingback':
				case 'trackback':
					?>
					<div class="comment-post-pingback">
						<span><?php esc_html_e( 'Pingback:', 'goto' ); ?></span><?php comment_author_link(); ?><?php edit_comment_link(esc_html__( 'Edit', 'goto' )); ?>
					</div>
			<?php
				break;
				default:
					?>
					<div id="comment-<?php comment_ID(); ?>" class="comment-item" <?php goto_schema_markup( 'comment' ); ?>>
						<div class="comment-avatar">
							<?php echo get_avatar( $comment, $size = 65 ); ?>
						</div>
						<div class="comment-content">
							<strong class="comment-author" <?php goto_schema_markup( 'comment_author' ); ?>>
								<a href="#comment-<?php comment_ID(); ?>" class="comment-author-name" <?php goto_schema_markup( 'comment_author_link' ); ?>><?php echo get_comment_author(); ?></a>
							</strong>
							<div class="comment-info">
								<time class="comment-time" <?php goto_schema_markup( 'comment_time' ); ?>><?php echo get_comment_date( get_option( 'date_format' ), get_comment_ID() ); ?></time>
								<?php
									echo get_comment_reply_link(array_merge($args, array(
										'depth' => $depth,
										'reply_text' => esc_html__( 'Reply', 'goto' ),
										'max_depth' => $args['max_depth']
									)));
								?>
								<?php edit_comment_link(esc_html__( 'Edit', 'goto' ), ' ', '' ); ?>
							</div>
							<div class="comment-text" <?php goto_schema_markup( 'comment_text' ); ?>>
								<?php if ( '0' == $comment->comment_approved ): ?>
									<em><?php esc_html_e( 'Your comment is awaiting moderation.', 'goto' ) ?></em>
								<?php endif; ?>
								<?php comment_text(); ?>
							</div>
						</div>
					</div>
			<?php
				break;
			endswitch;
		}
	endif;

	/*! blog post date
	------------------------------------------------->*/
	if( ! function_exists( 'goto_date_format' ) ):
		function goto_date_format() {
			$date_format = get_the_date( get_option( 'date_format' ) );
			return $date_format;
		}
	endif;

	/*! blog post info
	------------------------------------------------->*/
	if( ! function_exists( 'goto_post_info' ) ):
		function goto_post_info(){
			global $post;
			?>
			<li itemprop="datePublished" content="<?php echo get_the_time( 'c' ); ?>" class="screen-reader-text">
				<?php echo goto_date_format();/*post date*/ ?>
			</li>
			<li itemprop="author" class="if-author">
				<span><?php esc_html_e('By ', 'goto'); ?></span>
				<?php the_author_posts_link(); ?>
			</li>
			
			<?php if( ! empty( goto_blog_categories() ) ): ?>
				<li class="if-cat"><?php echo goto_blog_categories(); ?></li>
			<?php endif; ?>

			<?php if( is_single() ): ?>
			<li itemprop="commentCount" class="if-comment">
				<a href="<?php echo get_comments_link( $post->ID ); ?>" class="if-comment-link">
					<?php echo get_comments_number(); ?>
				</a>
			</li>
			<?php
			endif;
		}
	endif;


	/*! schema on blog single - better for SEO
	------------------------------------------------->*/
	if( ! function_exists( 'goto_seo_data' ) ):
		function goto_seo_data(){
			?>
			<div class="screen-reader-text">
				<?php /*heading*/ ?>
				<h2 <?php goto_schema_markup( 'title' ); ?>><?php echo get_the_title(); ?></h2>

				<?php
					/*thumbnail*/
					global $post;
					$thumbnail = get_the_post_thumbnail_url( $post->ID, 'thumbnail' );

					if( ! empty( $thumbnail ) ){
						$img_id  = get_post_thumbnail_id( $post->ID );
						$img_alt = goto_img_alt( $img_id, esc_attr__( 'Blog thumbnail', 'goto' ) );
						?>
						<span <?php goto_schema_markup( 'image' ); ?>>
							<img src="<?php echo esc_url( $thumbnail ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>">
							<meta itemprop="url" content="<?php echo esc_url( $thumbnail ); ?>" />
							<meta itemprop="width" content="770" />
							<meta itemprop="height" content="450" />
						</span>
				<?php }else{ ?>
					<span <?php goto_schema_markup( 'image' ); ?>>
						<img src="<?php echo get_template_directory_uri() . '/images/thumbnail-default.jpg'; ?>" alt="<?php esc_attr_e( 'Thumbnail', 'goto' ); ?>">
						<meta itemprop="url" content="<?php echo get_template_directory_uri() . '/images/thumbnail-default.jpg'; ?>" />
						<meta itemprop="width" content="100" />
						<meta itemprop="height" content="90" />
					</span>
				<?php } ?>

				<?php /*publisher*/ ?>
				<span class="author" <?php goto_schema_markup( 'publisher' ); ?>>
					<span itemprop="logo" itemscope="itemscope" itemtype="https://schema.org/ImageObject" >
						<meta itemprop="url" content="<?php echo esc_url( home_url( '/' ) ); ?>" />
						<meta itemprop="width" content="100" />
						<meta itemprop="height" content="100" />
					</span>
					<meta itemprop="name" content="<?php the_author(); ?>" />
				</span>

				<?php /*date modified*/ ?>
				<span itemprop="dateModified" class="updated">
					<time datetime="<?php echo esc_attr( get_the_modified_time( 'Y-m-d' ) ); ?>">
						<?php the_modified_date(); ?>
					</time>
				</span>

				<?php /*date published*/ ?>
				<span itemprop="datePublished" content="<?php echo get_the_time( 'c' ); ?>"><?php echo get_the_time( 'c' ); ?></span>

				<?php /*post categories*/ ?>
				<span itemprop="articleSection"><?php echo goto_blog_categories(); ?></span>
			</div>
		<?php }
	endif;

	/*! post thumbnail
	------------------------------------------------->*/
	if( ! function_exists( 'goto_post_thumbnail' ) ):
		function goto_post_thumbnail( $size = 'large' ){
			global $post;
			$thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id( $post->ID ), $size );
			if(empty($thumbnail)) return;

			$img_id  = get_post_thumbnail_id( $post->ID );
			$img_alt = goto_img_alt( $img_id, esc_attr__( 'Blog thumbnail', 'goto' ) );

			if( is_single() ){
			?>
				<div class="cover-image" <?php goto_schema_markup( 'image' ); ?>>
					<img src="<?php echo esc_url( $thumbnail[0] ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>">
					<meta itemprop="url" content="<?php echo esc_url($thumbnail[0]); ?>" />
					<meta itemprop="width" content="<?php echo esc_attr($thumbnail[1]); ?>" />
					<meta itemprop="height" content="<?php echo esc_attr($thumbnail[2]); ?>" />
					<time itemprop="datePublished" datetime="<?php echo get_the_time( 'c' ); ?>"><?php echo goto_date_format(); ?></time>
				</div>
			<?php }else{ ?>
				<a href="<?php the_permalink(); ?>" class="cover-image entry-image-link" <?php goto_schema_markup( 'image' ); ?>>
					<img src="<?php echo esc_url( $thumbnail[0] ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>">
					<meta itemprop="url" content="<?php echo esc_url( $thumbnail[0] ); ?>" />
					<meta itemprop="width" content="<?php echo esc_attr( $thumbnail[1] ); ?>" />
					<meta itemprop="height" content="<?php echo esc_attr( $thumbnail[2] ); ?>" />
					<?php if( is_sticky() ): ?>
						<span class="sticky-medal"><span><?php esc_html_e( 'Sticky', 'goto' ); ?></span></span>
					<?php endif; ?>
					<time itemprop="datePublished" datetime="<?php echo get_the_time( 'c' ); ?>"><?php echo goto_date_format(); ?></time>
				</a>
		<?php }
	}
	endif;

	/*! post format
	------------------------------------------------->*/
	if( ! function_exists( 'goto_post_format' ) ):
		function goto_post_format(){
			global $post;
			$format = get_post_format( $post->ID );

			if( is_single() ) {
				switch( $format ) {
					case 'video':
						$video_type = function_exists('fw_get_db_post_option') ? fw_get_db_post_option( $post->ID, 'video_type' ) : '';
						$video_id   = function_exists('fw_get_db_post_option') ? fw_get_db_post_option( $post->ID, 'video_id' ) : '';

						if( ! empty( $video_id ) ) {
							wp_enqueue_script( 'plyr-js' );

							wp_add_inline_script(
								'plyr.js',
								"document.addEventListener( 'DOMContentLoaded', function () {
									plyr.setup( document.getElementsByClassName( 'pf-video' )[0] );
								});",
								'after'
							);
						?>
							<div class="single-format-content pf-video">
								<div data-type="<?php echo esc_attr( $video_type ); ?>" data-video-id="<?php echo esc_attr( $video_id ); ?>" class="p-video"></div>
							</div>

						<?php
							}else{
								goto_post_thumbnail();
							}
						break;

					case 'gallery':
						$gallery = function_exists( 'fw_get_db_post_option' ) ? fw_get_db_post_option( $post->ID, 'd_gallery') : array();
						$arrows = function_exists( 'fw_get_db_post_option' ) ? fw_get_db_post_option( $post->ID, 'arrows', true ) : true;
						$dots = function_exists( 'fw_get_db_post_option' ) ? fw_get_db_post_option( $post->ID, 'dots', false ) : true;

						if( ! empty( $gallery ) ) {

							wp_enqueue_style( 'tiny-slider' );
							wp_enqueue_script( 'tiny-slider-js' );
							
							wp_add_inline_script(
								'tiny-slider-js',
								"window.addEventListener( 'load', function(){
									var sliderContainer = document.getElementById( 'post-type-gallery-slide' ),
										opt = JSON.parse( sliderContainer.getAttribute( 'data-tiny-slider' ) );

									opt.container = sliderContainer;
									var slider = tns( opt );
								} );",
								'after'
							);
							/*tiny slider options*/
							$options = array(
								"items"      => 1,
								"mouseDrag"  => true,
								"infinite"   => false,
								"controls"   => $arrows,
								"nav"        => $dots,
								"autoHeight" => true,
								'loop'       => false,
								"arrowKeys"  => true
							);
						?>
							<div class="single-format-content pf-gallery">
								<div id="post-type-gallery-slide" data-tiny-slider='<?php echo json_encode( $options ); ?>'>
									<?php
										foreach( $gallery as $key ){
											$imgs_alt = goto_img_alt( $key['attachment_id'], esc_attr__( 'Gallery image', 'goto' ) );
											echo '<img src="' . esc_url( $key['url'] ) . '" alt="' . esc_attr( $imgs_alt ) . '" />';
										}
									?>
								</div>
							</div>
						<?php
							}else{
								goto_post_thumbnail();
							}
						break;

					case 'audio':
						$d_audio = function_exists( 'fw_get_db_post_option' ) ? fw_get_db_post_option( $post->ID, 'd_audio' ): '';
						if( ! empty( $d_audio ) ) {
						?>
							<div class="single-format-content pf-audio">
								<?php echo ( $d_audio ); ?>
							</div>
						<?php
							}else{
								goto_post_thumbnail();
							}
						break;

					default:
						goto_post_thumbnail();
						break;
				}
			}else{
				goto_post_thumbnail();
			}

		}
	endif;

	/*! modify output widget search form
	------------------------------------------------->*/
	add_filter( 'get_search_form', 'goto_search_form_widget', 100 );
	function goto_search_form_widget( $form ) {
		$form = '<form role="search" method="get" class="search-form" action="' . esc_url( home_url( '/' ) ) . '" >';
		$form .= '<label class="screen-reader-text">' . esc_html__( 'Search for:', 'goto' ) . '</label>';
		$form .= '<input type="text" class="search-field" placeholder="' .esc_attr__( 'Search...', 'goto' ) .'" value="' . get_search_query() . '" name="s" required/>';
		$form .= '<button type="submit" class="search-submit ion-ios-search-strong"></button>';
		$form .= '</form>';

		return $form;
	}

	/*! modify output widget search form `for woocommerce`
	------------------------------------------------->*/
	add_filter( 'get_product_search_form' , 'goto_product_search_form_widget' );
	function goto_product_search_form_widget( $form ) {
		$form = '<form role="search" method="get" class="search-form" action="' . esc_url( get_permalink( wc_get_page_id( 'shop' ) ) ) . '" >';
		$form .= '<label class="screen-reader-text">' . esc_html__( 'Search for:', 'goto' ) . '</label>';
		$form .= '<input type="text" class="search-field" placeholder="'. esc_attr__( 'Search....', 'goto' ) .'" value="' . get_search_query() . '" name="s" required/>';
		$form .= '<button type="submit" class="search-submit ht-ico-search"></button>';
		$form .= '</form>';

		return $form;
	}

	/*! CUSTOM EXERPT MORE TEXT
	------------------------------------------------->*/
	function goto_more( $more ) {
		return '';
	}
	add_filter( 'excerpt_more', 'goto_more' );
}


/* TOUR
***************************************************/
{
	/*! DATE PICKER MARKUP
	------------------------------------------------->*/
	if( ! function_exists( 'goto_date_picker' ) ):
		function goto_date_picker( $selector ){
			wp_enqueue_script( 'datepicker-js' );

			wp_enqueue_style(
				'datepicker',
				get_template_directory_uri() . '/css/datepicker.css'
			);

			/*days of week*/
				$day = "'" . esc_attr_x( 'Sun', 'Day of the week', 'goto' ) . "',";
				$day .= "'" . esc_attr_x( 'Mon', 'Day of the week', 'goto' ) . "',";
				$day .= "'" . esc_attr_x( 'Tue', 'Day of the week', 'goto' ) . "',";
				$day .= "'" . esc_attr_x( 'Web', 'Day of the week', 'goto' ) . "',";
				$day .= "'" . esc_attr_x( 'Thu', 'Day of the week', 'goto' ) . "',";
				$day .= "'" . esc_attr_x( 'Fri', 'Day of the week', 'goto' ) . "',";
				$day .= "'" . esc_attr_x( 'Sat', 'Day of the week', 'goto' ) . "',";

			/*months of year*/
				$month = "'" . esc_attr_x( 'January', 'Month of the year', 'goto' ) . "',";
				$month .= "'" . esc_attr_x( 'February', 'Month of the year', 'goto' ) . "',";
				$month .= "'" . esc_attr_x( 'March', 'Month of the year', 'goto' ) . "',";
				$month .= "'" . esc_attr_x( 'April', 'Month of the year', 'goto' ) . "',";
				$month .= "'" . esc_attr_x( 'May', 'Month of the year', 'goto' ) . "',";
				$month .= "'" . esc_attr_x( 'June', 'Month of the year', 'goto' ) . "',";
				$month .= "'" . esc_attr_x( 'July', 'Month of the year', 'goto' ) . "',";
				$month .= "'" . esc_attr_x( 'August', 'Month of the year', 'goto' ) . "',";
				$month .= "'" . esc_attr_x( 'September', 'Month of the year', 'goto' ) . "',";
				$month .= "'" . esc_attr_x( 'October', 'Month of the year', 'goto' ) . "',";
				$month .= "'" . esc_attr_x( 'November', 'Month of the year', 'goto' ) . "',";
				$month .= "'" . esc_attr_x( 'December', 'Month of the year', 'goto' ) . "',";

			/*button label*/
				$today = esc_attr_x( 'Today', 'Day of the week', 'goto' );
				$clear = esc_attr__( 'Clear', 'goto' );
				$close = esc_attr__( 'Close', 'goto' );

			wp_add_inline_script(
				'datepicker-js',
				"document.addEventListener( 'DOMContentLoaded', function () {
					if ( ! document.querySelector( '{$selector}' ) ) {
						return;
					}
					TinyDatePicker( '{$selector}', {
						lang: {
							days: [ {$day} ],
							months: [ {$month} ],
							today: '{$today}',
							clear: '{$clear}',
							close: '{$close}',
						},
						mode: 'dp-below',
						min: new Date(),
					});
				});",
				'after'
			);
		}
	endif;

	/* LIMIT POST EXCERPT
	***************************************************/
	if( ! function_exists( 'goto_limit_excerpt' ) ):
		function goto_limit_excerpt( $limit ) {
			$excerpt = get_the_excerpt();
			$limit++;

			if ( mb_strlen( $excerpt ) > $limit ) {
				$subex = mb_substr( $excerpt, 0, $limit - 5 );
				$exwords = explode( ' ', $subex );
				$excut = - ( mb_strlen( $exwords[ count( $exwords ) - 1 ] ) );
				if ( $excut < 0 ) {
					echo mb_substr( $subex, 0, $excut );
				} else {
					echo wp_kses_post( $subex );
				}
				echo '...';
			} else {
				echo wp_kses_post( $excerpt );
			}
		}
	endif;

	/* TOUR HEADER DEFINE
	***************************************************/
	if( ! function_exists( 'goto_tour_header' ) ):
		function goto_tour_header(){
			if( ! is_singular( 'ht_tour' ) ) return 'not-tour';

			$id    = get_queried_object_id();
			$style = get_theme_mod( 'tour_header_layout_cfg', 'tour-1' );
			if( 'default' != fw_get_db_post_option( $id, 'style' ) ){
				$style = fw_get_db_post_option( $id, 'style' );
			}

			return $style;
		}
	endif;

	/* GET TOUR RATING AVERAGE
	***************************************************/
	if ( ! function_exists( 'goto_tour_rating_average' ) ) {
		function goto_tour_rating_average( $list_ids = array() ) {
			if ( empty( $list_ids ) ) {
				return array();
			}

			$rating_arr = array();

			foreach ( $list_ids as $pid ) {
				$rating = function_exists( 'fw_ext_feedback_stars_get_post_rating' ) ? fw_ext_feedback_stars_get_post_rating( $pid ) : array( 'count' => 0 );

				if ( isset( $rating['average'] ) ) {
					array_push( $rating_arr, intval( $rating['average'] ) );
				}
			}

			return $rating_arr;
		}
	}

	/* GET COUNT RATING AVERAGE
	***************************************************/
	if ( ! function_exists( 'goto_count_tour_rating_average' ) ) {
		function goto_count_tour_rating_average( $arr = array() ) {
			$star_1 = isset( $arr[1] ) ? $arr[1] : 0;
			$star_2 = isset( $arr[2] ) ? $arr[2] : 0;
			$star_3 = isset( $arr[3] ) ? $arr[3] : 0;
			$star_4 = isset( $arr[4] ) ? $arr[4] : 0;
			$star_5 = isset( $arr[5] ) ? $arr[5] : 0;

			$s1 = $star_1 + $star_2 + $star_3 + $star_4 + $star_5;
			$s2 = $star_2 + $star_3 + $star_4 + $star_5;
			$s3 = $star_3 + $star_4 + $star_5;
			$s4 = $star_4 + $star_5;

			return array( $s1, $s2, $s3, $s4 );
		}
	}
}


/* PLUGINS
***************************************************/
{
	/* REMOVE REV SLIDER METABOX
	***************************************************/
	if ( is_admin() ) {
		add_action( 'registered_post_type', 'goto_remove_rev_slider_meta_boxes' );
		function goto_remove_rev_slider_meta_boxes( $post_type ){
			add_action( 'do_meta_boxes', function () use ( $post_type ) {
				remove_meta_box( 'mymetabox_revslider_0', $post_type, 'normal' );
			});
		}
	}

	/*! REMOVE CONTACT FORM 7 CSS
	------------------------------------------------->*/
	add_filter( 'wpcf7_load_css', '__return_false' );

	/*! DISABLE THE CONFIGURATION VALIDATOR
	------------------------------------------------->*/
	add_filter( 'wpcf7_validate_configuration', '__return_false' );

	/*! REMOVE FEEDBACK CSS
	------------------------------------------------->*/
	add_action( 'wp_enqueue_scripts', 'goto_assets_action', 100 );
	function goto_assets_action() {
		wp_dequeue_style( 'fw-extension-feedback-stars-styles' );       
	}

	/* GET PAGE BY TEMPLATE NAME
	***************************************************/
	if( ! function_exists( 'goto_template_name' ) ):
		function goto_template_name( $name = 'page-templates/tour-list.php' ){
			$url = '#';

			$q = new WP_Query( array(
				'post_type' => 'page',
				'meta_key'  => '_wp_page_template',
				'meta_value'=> $name
			));

			if( $q->have_posts() ){
				while( $q->have_posts() ):
					$q->the_post();
					$url = get_the_permalink( get_the_ID() );
				endwhile;
			}

			wp_reset_postdata();
			
			return $url;
		}
	endif;
}

/* ELEMENTOR
***************************************************/
{
	/* CHECK IF ELEMENTOR IS ACTIVE
	***************************************************/
	if( ! function_exists( 'goto_is_elementor' ) ):
		function goto_is_elementor(){
			return defined( 'ELEMENTOR_VERSION' );
		}
	endif;

	if( ! function_exists( 'goto_is_elementor_pro' ) ):
		function goto_is_elementor_pro(){
			return defined( 'ELEMENTOR_PRO_VERSION' );
		}
	endif;

	/* CHECK IF PAGE BUILD WITH ELEMENTOR
	***************************************************/
	if( ! function_exists( 'goto_elementor_page' ) ):
		function goto_elementor_page( $id ){
			return get_post_meta( $id, '_elementor_edit_mode', true );
		}
	endif;

	/* PAGE OPTION
	***************************************************/
	if( ! function_exists( 'goto_page_opt' ) ):
		function goto_page_opt( $_id = null, $key = '' ){
			if( true == goto_is_elementor() && true == goto_elementor_page( $_id ) ){
				$document = \Elementor\Plugin::$instance->documents->get( $_id );

				if( $document ){
					return $document->get_settings( $key );
				}

				return false;
			}
		}
	endif;

	/* TOURS WIDGET: GET NARROW DATA SOURCE
	***************************************************/
	if( ! function_exists( 'goto_get_narrow_data' ) ):
		function goto_get_narrow_data( $data ){
			$output = array();

			switch( $data ):
				case 'cat':
					$tour_cat = get_terms( 'ht_tour_cat' );
					$output   = wp_list_pluck( $tour_cat, 'name', 'term_id' );
					break;

				case 'dest':
					$dest_args = array(
						'post_type'           => 'ht_dest',
						'post_status'         => 'publish',
						'ignore_sticky_posts' => 1,
						'posts_per_page'      => -1,
					);
					$dest_q   = new WP_Query( $dest_args );
					$output = wp_list_pluck( $dest_q->posts, 'post_title', 'ID' );
					break;
					
				case 'post':
					$tour_args = array(
						'post_type'           => 'ht_tour',
						'post_status'         => 'publish',
						'ignore_sticky_posts' => 1,
						'posts_per_page'      => -1,
					);
					$tour_q   = new WP_Query( $tour_args );
					$output = wp_list_pluck( $tour_q->posts, 'post_title', 'ID' );
					break;

				case 'blog_cat':
					$blog_cat = get_terms( 'category' );
					$output   = wp_list_pluck( $blog_cat, 'name', 'term_id' );
					break;
			endswitch;

			return $output;
		}
	endif;
}


/* PARTIAL REFRESH
***************************************************/
{
	/*! MENU LAYOUT
	------------------------------------------------->*/
	if( ! function_exists( 'goto_default_menu_item' ) ):
		function goto_default_menu_item(){
		?>
			<ul class="theme-primary-menu">
				<li>
					<a class="add-menu" href="<?php echo esc_url( get_admin_url() . 'nav-menus.php' ); ?>"><?php esc_html_e( 'Add Menu', 'goto' ); ?></a>
				</li>
			</ul>
		<?php
		}
	endif;

	if( ! function_exists( 'goto_menu_layout' ) ):
		function goto_menu_layout(){
			$layout = get_theme_mod( 'header_layout_cfg', 'layout-1' );
			$blog_layout = get_theme_mod( 'blog_header_layout_cfg', 'layout-1' );
			$tour_layout = get_theme_mod( 'tour_menu_layout_cfg', 'layout-1' );

			if( goto_blog() ){
				$layout = $blog_layout;
			}

			if( is_singular( 'ht_tour' ) ){
				$layout = $tour_layout;
			}

			$id = get_queried_object_id();

			/*CUSTOM PAGE HEADER FOR PAGE - ELEMENTOR SETTINGS*/
			$page_menu_layout = true == goto_elementor_page( $id ) ? goto_page_opt( $id, 'page_menu_layout' ) : null;
			if( 'default' != $page_menu_layout && null != $page_menu_layout ){
				$layout = $page_menu_layout;
			}

			switch( $layout ):
				case 'layout-1':
					?>
					<div class="theme-header-layout header-layout-1">
						<header class="header-box">
							<?php goto_edit_location( 'hd1' ); /*header edit location*/ ?>

							<div class="container" <?php goto_schema_markup( 'navigation' ); ?>>
								<?php goto_logo_image(); ?>

								<span class="screen-reader-text"><?php esc_html_e( 'Primary Menu', 'goto' ); ?></span>
								<div class="theme-menu-box">
									<?php
										if( has_nav_menu( 'primary' ) ):
											wp_nav_menu( array(
												'theme_location' => 'primary',
												'menu_class'     => 'theme-primary-menu',
												'container'      => '',
											));
										else:
											goto_default_menu_item();
										endif;
									?>
									<button id="theme-search-btn" class="ion-ios-search-strong"></button>
								</div>
							</div>
						</header>
						<span id="menu-overlay"></span>
					</div>
					<?php
					break;
				case 'layout-2':
					?>
					<div class="theme-header-layout header-layout-2">
						<header class="header-box">
							<?php goto_edit_location( 'hd2' ); /*header edit location*/ ?>

							<div class="container" <?php goto_schema_markup( 'navigation' ); ?>>
								<div id="hd2-logo">
									<?php goto_logo_image(); ?>
								</div>

								<div class="theme-menu-box">
									<span class="screen-reader-text"><?php esc_html_e( 'Primary Menu', 'goto' ); ?></span>
									<?php
										if( has_nav_menu( 'primary' ) ):
											wp_nav_menu( array(
												'theme_location' => 'primary',
												'menu_class'     => 'theme-primary-menu',
												'container'      => '',
											));
										else:
											goto_default_menu_item();
										endif;
									?>
									<button id="theme-search-btn" class="ion-ios-search-strong"></button>
								</div>
							</div>
						</header>
						<span id="menu-overlay"></span>
					</div>
					<?php
					break;
				case 'layout-3':
					$menu_id = get_theme_mod( 'hd3_menu_id', 'default' );
					?>
					<div class="theme-header-layout header-layout-3">
						<header class="header-box">

							<?php goto_edit_location( 'hd3' ); /*header edit location*/ ?>

							<div class="container" <?php goto_schema_markup( 'navigation' ); ?>>

								<span class="screen-reader-text"><?php esc_html_e( 'Primary Menu', 'goto' ); ?></span>
								<?php
									if( 'default' != $menu_id ){
										wp_nav_menu( array(
											'menu'       => $menu_id,
											'menu_class' => 'theme-primary-menu',
											'container'  => '',
										));
									}else{
										if( has_nav_menu( 'primary' ) ){
											wp_nav_menu( array(
												'theme_location' => 'primary',
												'menu_class'     => 'theme-primary-menu',
												'container'      => '',
											));
										}else{
										?>
											<a class="add-menu" href="<?php echo esc_url( get_admin_url() . 'nav-menus.php' ); ?>"><?php esc_html_e( 'Add Menu', 'goto' ); ?></a>
										<?php
										}
									}
								?>

								<?php goto_logo_image(); ?>

								<div class="header-right">
									<span id="theme-search-btn" class="search-btn ion-ios-search-strong"><?php echo esc_html_x( 'Search', 'Search form label on header menu', 'goto' ); ?></span>

									<?php if( ! empty( get_theme_mod( 'c_menu3_tel', '+1 800 311 3006' ) ) ): ?>
										<span class="tel-number"><?php echo esc_html( get_theme_mod( 'c_menu3_tel', '+1 800 311 3006' ) ); ?></span>
									<?php endif; ?>
								</div>

							</div>
						</header>
						<span id="menu-overlay"></span>
					</div>
					<?php
					break;
			endswitch;
		}
	endif;

	/*! PAGE HEADER
	------------------------------------------------->*/
	if( ! function_exists( 'goto_page_header' ) ):
		function goto_page_header(){
			/*not showing page header on 404 and single tour page*/
			if( is_404() || is_singular( 'ht_tour' ) ) return;

			/* CUSTOMIZER
			***************************************************/
			$c_header = get_theme_mod( 'c_header', true );

			/* PAGE OPTIONS
			***************************************************/
			$pid = get_queried_object_id();
			$p_header = function_exists( 'fw_get_db_post_option' ) ? fw_get_db_post_option( $pid, 'p_bread', 'default' ) : 'default';


			/*! SHOW PAGE HEADER `true` OR `false` VALUE
			------------------------------------------------->*/
			$show_page_header = $c_header;

			$page_header_style = [];

			/*PAGE TITLE*/
			$title = get_the_title();

			/*CUSTOMIZEE BLOG TITLE*/
			$blog_title = get_theme_mod( 'blog_title', 'Blog' );

			/*CUSTOM PAGE HEADER FOR SINGLE `POST`*/
			if( function_exists( 'FW' ) && is_singular( 'post' ) ):
				$gadget = isset( $p_header['gadget'] ) ? $p_header['gadget'] : 'default';

				if( 'disable' == $gadget ){
					$show_page_header = false;
				}

				/*! Override value if enable custom page header
				------------------------------------------------->*/
				if( 'custom' == $gadget ){

					$show_page_header = true;

					/*page title*/
					$title = !empty( $p_header['custom']['p_bread_title'] ) ? $p_header['custom']['p_bread_title'] : get_the_title();

					/*header bg*/
					$p_header_bg = isset( $p_header['custom']['p_bread_bg'] ) ? $p_header['custom']['p_bread_bg'] : '';

					if( isset( $p_header_bg['gadget'] ) && 'color_bg' == $p_header_bg['gadget'] ){
						$page_header_style[] = 'background-color:' . $p_header_bg['color_bg']['color_bg_data'];
					}else{
						if( !empty( $p_header_bg['img_bg']['img_bg_data'] )):
							$page_header_style[] = 'background-image:url(' . $p_header_bg['img_bg']['img_bg_data']['url'] . ')';
						endif;
					}
				}
			endif;

			/*CUSTOM PAGE HEADER FOR PAGE - ELEMENTOR SETTINGS*/
			$page_header = null;
			if( 'builder' == goto_elementor_page( $pid ) && !is_single()  ){
				$page_header         = goto_page_opt( $pid, 'page_header' );
				$feature_image       = goto_page_opt( $pid, 'post_featured_image' );
				if( ! empty( $feature_image['url'] ) ){
					$page_header_style = [];
					$page_header_style[] = 'background-image:url(' . $feature_image['url'] . ')';
				}
			}
			
			if( '' === $page_header ){
				$show_page_header = false;
			}

			/*! Custom page header image on Tour&Blog category
			------------------------------------------------->*/
			if( is_tax( 'ht_tour_cat' ) || is_category() || is_tax( 'ht_dest_cat' ) || is_tag() || is_tax( 'post-type' ) || is_tax( 'typetype' ) ){
				global $wp_query;
				$term = $wp_query->get_queried_object();
				$term_id = $term->term_id;

				$feature_image = fw_get_db_term_option( $term_id, 'ht_tour_cat', 'featured_image', 'none' );
				$page_header_style = [];
				if( $feature_image != 'none' ){
					$page_header_style[] = 'background-image:url(' . $feature_image['url'] . ')';
				}
			}

			/*! OUTPUT PAGE HEADER STYLE
			------------------------------------------------->*/
			$page_header_style = ! empty( $page_header_style ) ? 'style="' . implode( '; ', $page_header_style ) . '"' : '';

			/*PARALLAX*/
			$parallax        = get_theme_mod( 'c_parallax', true );
			$parallax_speed  = get_theme_mod( 'c_parallax_speed', true );
			$parallax_output = '';

			if( true == $parallax ){
				$parallax_output = 'id="page-header-parallax" data-speed="' . absint( $parallax_speed ) . '"';
			}
			

			if( true == $show_page_header ): ?>
				<div class="page-header" <?php echo wp_kses_post( $page_header_style ); ?> <?php echo wp_kses_post( $parallax_output ); ?>>
					<div class="container">
						<?php /*page title*/ ?>
						<h1 class="page-title entry-title"><?php goto_page_title( $blog_title, $shop_title = '', $title ); ?></h1>
						<div id="theme-bread">
							<?php goto_theme_breadcrumbs(); ?>
						</div>
					</div>
				</div>
			<?php endif;
		}
	endif;

	/*! PAGE TITLE
	------------------------------------------------->*/
	if( ! function_exists( 'goto_page_title' ) ):
		function goto_page_title( $blog_title, $shop_title, $title ){
			if ( is_day() ):
				printf( esc_html__( 'Daily Archives: %s', 'goto'), get_the_date() );
			elseif ( is_month() ):
				printf( esc_html__( 'Monthly Archives: %s', 'goto'), get_the_date( esc_html_x( 'F Y', 'monthly archives date format', 'goto' ) ) );
			elseif ( is_home() ):
				echo esc_html( $blog_title );
			elseif( is_author() ):
				$author = get_query_var( 'author_name' ) ? get_user_by( 'slug', get_query_var( 'author_name' ) ) : get_userdata( get_query_var( 'author' ) );
				echo esc_html( $author->display_name );
			elseif ( is_year() ):
				printf( esc_html__( 'Yearly Archives: %s', 'goto' ), get_the_date( esc_html_x( 'Y', 'yearly archives date format', 'goto') ) );
			elseif( class_exists( 'WooCommerce' ) && is_shop() ):
				echo esc_html( $shop_title );
			elseif( class_exists( 'WooCommerce' ) && is_product_tag() || is_tag() ):
				esc_html_e( 'Tags: ', 'goto' ); single_tag_title();
			elseif( is_page() || is_single() ):
				echo ! empty( $title ) ? esc_html( $title ): esc_html__( 'This post has no title', 'goto' );
			elseif( is_tax() ):
				global $wp_query;
				$term = $wp_query->get_queried_object();
				$tex_title = $term->name;
				echo esc_html( $tex_title );
			elseif( is_search() ):
				esc_html_e( 'Search results', 'goto' );
			else:
				esc_html_e( 'Archives', 'goto' );
			endif;
		}
	endif;

	/*! BREADCRUMBS
	------------------------------------------------->*/
	if( ! function_exists( 'goto_theme_breadcrumbs' ) ):
		function goto_theme_breadcrumbs(){
			if ( function_exists( 'fw_ext_breadcrumbs' ) && true == get_theme_mod( 'c_navigation', true )  ) fw_ext_breadcrumbs();
		}
	endif;

	/*! FOOTER LOGO
	------------------------------------------------->*/
	if( ! function_exists( 'goto_footer_logo' ) ):
		function goto_footer_logo(){
			if( ! empty( get_theme_mod( 'ft_logo' ) ) ):
			?>
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="footer-logo">
					<img src="<?php echo esc_url( get_theme_mod( 'ft_logo' ) ); ?>" alt="<?php esc_attr_e( 'Footer logo', 'goto' ); ?>">
				</a>
			<?php
			endif;
		}
	endif;
}


/* AJAX
***************************************************/
{
	/*! CREATE AJAX URL
	------------------------------------------------->*/
	{
		add_action( 'wp_enqueue_scripts', 'goto_ajax_url', 999 );
		function goto_ajax_url(){
			wp_localize_script( 'goto-custom-script', 'goto_ajax', array(
				'url' => admin_url( 'admin-ajax.php' )
			));
		}
	}

	/*! TOUR LIST FILTER
	------------------------------------------------->*/
	{
		/* TOUR LIST PAGINATION
		***************************************************/
		if( ! function_exists( 'goto_tour_list_ajax_pagi' ) ):
			function goto_tour_list_ajax_pagi( $query = null, $paged = 1 ) {
				if ( ! $query ) {
					return;
				}

				$pagi = paginate_links( array(
					'base'      => '%_%',
					'type'      => 'array',
					'total'     => $query->max_num_pages,
					'format'    => '#page=%#%',
					'current'   => max( 1, $paged ),
					'prev_text' => '',
					'next_text' => ''
				) );

				if ( $query->max_num_pages > 1 ):
				?>
					<ul class="ht-pagination tour-list-pagi">
						<?php foreach ( $pagi as $p ): ?>
							<li><?php echo wp_kses_post( $p ); ?></li>
						<?php endforeach; ?>
					</ul>
				<?php
				endif;
			}
		endif;

		/* GET RESULT COUNT
		***************************************************/
		if( ! function_exists( 'goto_result_count' ) ):
			function goto_result_count( $get_total, $per_page = 10, $paged = 1 ){
				$total = count( $get_total );

				if ( $total < 1 ) {
					$result_count = '<p class="no-post-founds">' . esc_html__( 'Sorry, nothing found', 'goto' ) . '</p>';
					return $result_count;
				}

				$result_count = '';
				if ( $total <= $per_page || -1 === $per_page ) {
					/* translators: %d: total results */
					$result_count = sprintf( _n( 'Showing the single result', 'Showing all %d results', $total, 'goto' ), $total );
				}else{
					$first = ( $per_page * $paged ) - $per_page + 1;
					$last  = min( $total, $per_page * $paged );
					/* translators: 1: first result 2: last result 3: total results */
					$result_count = sprintf( _nx( 'Showing the single result', 'Showing %1$d-%2$d of %3$d results', $total, 'with first and last result', 'goto' ), $first, $last, $total );
				}
				return $result_count;
			}
		endif;

		if ( ! function_exists( 'goto_get_tour_list' ) ) {
			/**
			 * Get tour list id
			 *
			 * @param array $args  The query argument.
			 * @param array $value The value to compare.
			 */
			function goto_get_tour_list( $args, $value ) {
				$args['posts_per_page'] = -1;
				$args['fields']         = 'ids';
				$list                   = array();
				$query                  = get_posts( $args );

				if ( empty( $query ) || ! function_exists( 'FW' ) ) {
					return $list;
				}

				foreach ( $query as $pid ) {
					$price       = fw_get_db_post_option( $pid, 'price' );
					$sale_price  = fw_get_db_post_option( $pid, 'sale_price' );
					$final_price = ! empty( $sale_price ) && $sale_price > 0 ? $sale_price : $price;

					$list[ $pid ] = $final_price;
				}

				$min_price = empty( $value['min_price'] ) ? 0 : $value['min_price'];
				$max_price = empty( $value['max_price'] ) ? 0 : $value['max_price'];

				if ( in_array( $value['orderby'], [ 'price-high-to-low', 'price-low-to-high' ] ) ) {
					if ( 'price-high-to-low' == $value['orderby'] ) {
						arsort( $list );
					} else {
						asort( $list );
					}
				}

				if ( $min_price >= 0 || $max_price >= 0 ) {
					foreach ( $list as $k => $v ) {
						if ( $v >= $min_price && ( 0 == $max_price || $v <= $max_price ) ) {
							$new_arr[ $k ] = $v;
						}
					}

					$list = $new_arr;
				}

				return array_keys( $list );
			}
		}

		/* TOUR LIST QUERY POST
		***************************************************/
		if( ! function_exists( 'goto_tour_list_query' ) ):
			function goto_tour_list_query( $q, $view_type = 'list', $paged = 1 ) {
				$unit        = function_exists( 'fw_get_db_ext_settings_option' ) ? goto_unit( fw_get_db_ext_settings_option( 'tour', 'unit' ) ) : '&#36;';
				$symbol_post = function_exists( 'fw_get_db_ext_settings_option' ) ? fw_get_db_ext_settings_option( 'tour', 'symbol-pos' )  : 'left';
				
				while( $q->have_posts() ):
					$q->the_post();

					if ( ! function_exists( 'FW' ) ) {
						return;
					}

					$price      = fw_get_db_post_option( get_the_ID(), 'price' );
					$sale_price = fw_get_db_post_option( get_the_ID(), 'sale_price' );				
					$days       = fw_get_db_post_option( get_the_ID(), 'days' );
					$start_date = fw_get_db_post_option( get_the_ID(), 'date' );

					// Start time, this override for `$start_date`.
					$start_time   = fw_get_db_post_option( get_the_ID(), 'start_time' );
					$availability = fw_get_db_post_option( get_the_ID(), 'avaibility' );

					// Get rating on front-end.
					$rating = function_exists( 'fw_ext_feedback_stars_get_post_rating' ) ? fw_ext_feedback_stars_get_post_rating() : array( 'count' => 0 );
					$item   = isset( $rating['average'] ) ? intval( $rating['average'] ) : 0;

					// Update Rating Average star on post-meta database.
					fw_set_db_post_option( get_the_ID(), 'rating', $item );

					$img_id  = get_post_thumbnail_id( get_the_ID() );
					$img_alt = goto_img_alt( $img_id, esc_attr__( 'Tour list image', 'goto' ) );
					$img_src = ! empty( $img_id ) ? get_the_post_thumbnail_url( get_the_ID(), 'medium_large' ) : get_template_directory_uri() . '/images/tour/370x240.png';

					$tour_cat = get_the_term_list( get_the_ID(), 'ht_tour_cat', '', ', ' );
					?>
						<div class="tl-item">
							<div class="tl-image">
								<?php if( 0 != $price ): ?>
									<span class="tli-price">
										<span><?php goto_price_unit( $symbol_post, $unit, $price ); ?></span>
										<?php if( ! empty( $sale_price ) ): ?>
											<span class="tli-sale-price"><?php goto_price_unit( $symbol_post, $unit, $sale_price ); ?></span>
										<?php endif; ?>
									</span>
								<?php endif; ?>
								<a href="<?php the_permalink(); ?>">
									<img src="<?php echo esc_url( $img_src ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>">
								</a>
							</div>
							<div class="tl-content">
								<h3 class="tlc-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>

								<?php if( 'grid' == $view_type ): ?>
									<div class="tlc-summary">
										<?php goto_limit_excerpt( 140 ); ?>
									</div>
								<?php endif; ?>

								<div class="tlc-info">
									<?php if( $rating['count'] > 0 ): ?>
										<span class="tour-average"><?php echo esc_html( round( $rating['average'], 1 ) ); ?></span>
									<?php endif; ?>

									<span class="tour-review-count">
										<?php
											printf(
												_nx(
													'1 review',
													'%s review(s)',
													number_format_i18n( $rating['count'] ),
													'review count',
													'goto'
												),
												number_format_i18n( $rating['count'] )
											);
										?>
									</span>
									<?php if( 'list' == $view_type && ! empty( $tour_cat ) ): ?>
										<span class="tlc-cat"><?php echo wp_kses_post( $tour_cat ); ?></span>
									<?php endif; ?>
								</div>

								<?php if( 'list' == $view_type ): ?>
									<div class="tlc-summary">
										<?php goto_limit_excerpt( 140 ); ?>
									</div>
								<?php endif; ?>

								<div class="tlc-short-info">
									<?php if( ! empty( $days ) ): ?>
										<div class="tlc-short-item">
											<span class="goto-icon-clock"></span>
											<strong>
												<?php
													printf(
														_nx(
															'1 day',
															'%1$s days',
															$days,
															'day of the week',
															'goto'
														),
														$days
													);
												?>
											</strong>
										</div>
									<?php endif; ?>

									<?php if( 'list' == $view_type ): ?>
										<?php if( ! empty( $start_date ) ): ?>
											<div class="tlc-short-item">
												<span class="goto-icon-calendar-2"></span>
												<strong>
													<?php
														if ( ! empty( $start_time ) ) {
															echo esc_html( $start_time );
														} else {
															echo date( get_option( 'date_format' ), strtotime( $start_date ) );
														}
													?>
												</strong>
											</div>
										<?php endif; ?>
										
										<?php if( ! empty( $availability ) ): ?>
											<div class="tlc-short-item">
												<span class="goto-icon-group"></span>
												<strong><?php echo esc_html__( 'Availability:', 'goto' ) . ' ' .  esc_html( $availability ); ?></strong>
											</div>
										<?php endif; ?>
									<?php endif; ?>
								</div>
							</div>
						</div>
					<?php
				endwhile;

				wp_reset_postdata();

				goto_tour_list_ajax_pagi( $q, $paged );
			}
		endif;

		/* TOUR LIST AJAX CONTENT
		***************************************************/
		add_action( 'wp_ajax_tl_filter', 'goto_tour_list_filter' );
		add_action( 'wp_ajax_nopriv_tl_filter', 'goto_tour_list_filter' );
		function goto_tour_list_filter(){
			/*RESPONSE DATA FOR FRONTEND*/
			$response = array(
				'status'    => 500,
				'message'   => esc_html__( 'Something is wrong, please try again later...', 'goto' ),
				'content'   => false,
				'found'     => 0,
				'view_type' => 'list'
			);

			/*CHECK WORDPRESS NONCE*/
			check_ajax_referer( 'tour_list_nonce', 'tour_nonce', false );
			if( ! isset( $_POST['tour_nonce'] ) ) {
				die( json_encode( $response ) );
			}

			/*CONVERT SUBMIT DATA TO PHP ARRAY*/
			$data = isset( $_POST['formvalue'] ) ? json_decode( stripslashes( wp_unslash( $_POST['formvalue'] ) ), true ) : array();

			if ( empty( $data ) ) {
				return json_encode( $response );
			}

			/*VARIABLE*/
			$date_value   = $days_min = $days_max  = $view_type = $kw = $dest_id = $cat_id = $rating = $price_order = '';
			$paged        = get_query_var( 'page' ) ? get_query_var( 'page' ) : get_query_var( 'paged' );
			$availability = $price_min = $price_max = 0;
			$post_ids     = array();
			$order        = 'ASC';
			$order_by     = 'none';

			foreach( $data as $k ){
				/*CATEGORY ID*/
				if( isset( $k['type'] ) && 'cat' == $k['type'] ){
					$cat_id = $k['id'];
				}
				/*DESTINATION ID*/
				if( isset( $k['type'] ) && 'dest' == $k['type'] ){
					$dest_id = $k['id'];
				}
				/*RATING ID*/
				if( isset( $k['type'] ) && 'rating' == $k['type'] ){
					$rating = $k['id'];
				}
				switch( $k['name'] ){
					/*PRICE MIN*/
					case 'min_price':
						$price_min = absint( $k['value'] );
						break;

					/*PRICE MAX*/
					case 'max_price':
						$price_max = absint( $k['value'] );
						break;

					/*DAYS MIN*/
					case 'min_days':
						$days_min = absint( $k['value'] );
						break;

					/*DAYS MAX*/
					case 'max_days':
						$days_max = absint( $k['value'] );
						break;

					/*PAGED*/
					case 'paged':
						$paged = absint( $k['value'] );
						break;

					/*QUERY BY DATE*/
					case 'date':
						$date_value = esc_html( $k['value'] );
						break;

					/*VIEW TYPE*/
					case 'view_type':
						$view_type = esc_html( $k['value'] );
						break;

					/*KEYWORDS*/
					case 'keywords':
						global $wpdb;
						$kw = esc_html( sanitize_text_field( $k['value'] ) );

						$tour_ids = $wpdb->get_col(
							"SELECT ID
							FROM $wpdb->posts
							WHERE UCASE( post_title )
							LIKE '%$kw%'
							AND post_type='ht_tour'
							AND post_status='publish'" );

						$get_dest_ids = $wpdb->get_col(
							"SELECT ID
							FROM $wpdb->posts
							WHERE UCASE( post_title )
							LIKE '%$kw%'
							AND post_type='ht_dest'
							AND post_status='publish'" );

						$tour_ids_related_with_dest = array();
						if( ! empty( $get_dest_ids ) ){
							foreach( $get_dest_ids as $k ){
								$tour_ids_related_with_dest[] = function_exists( 'fw_get_db_post_option' ) ? fw_get_db_post_option( $k, 'tour_id' ) : array();
							}
							$tour_ids_related_with_dest = call_user_func_array( 'array_merge_recursive', $tour_ids_related_with_dest );   
						}

						$post_ids = array_unique( array_merge( $tour_ids, $tour_ids_related_with_dest ) );
						break;

					/*AVAIBILITY*/
					case 'avaibility':
							$availability = absint( $k['value'] ) ;
						break;

					/*SORTBY*/
					case 'short_by':
						switch ( $k['value'] ) {
							default:
							case 'newest-to-oldest':
								$order_by = 'date';
								$order    = 'DESC';
								break;
							case 'tour-name-ascending':
								$order_by = 'title';
								break;
							case 'tour-name-descending':
								$order_by = 'title';
								$order    = 'DESC';
								break;
							case 'price-low-to-high':
							case 'price-high-to-low':
								$price_order = $k['value'];
								break;
						}
						break;
				}
			}

			/*ARGS*/
			$per_page = get_option( 'posts_per_page', 10 );
			
			$args = array(
				'post_type'      => 'ht_tour',
				'post_status'    => 'publish',
				'posts_per_page' => $per_page,
				'orderby'        => $order_by,
				'order'          => $order,
				'paged'          => $paged,
				'meta_query'     => array(
					array(
						'key'     => 'days',
						'value'   => array( $days_min, $days_max ),
						'compare' => 'BETWEEN',
						'type'    => 'NUMERIC'
					),
					array(
						'key'     => 'avaibility',
						'value'   => $availability,
						'compare' => '>=',
						'type'    => 'NUMERIC'
					),
				),
			);

			// Filter by rating average.
			if ( $rating && 'all' != $rating ) {
				$args['meta_query'] = array(
					array(
						'key'     => 'rating',
						'value'   => $rating,
						'compare' => '>=',
						'type'    => 'NUMERIC'
					),
				);
			}

			/*QUERY BY DATE*/
			if( ! empty( $date_value ) ){
				$date_meta = date( 'Ymd', strtotime( $date_value ) );
				unset( $args['meta_query'] );
				$args['meta_query'] = array(
					array(
						'key'     => 'days',
						'value'   => array( $days_min, $days_max ),
						'compare' => 'BETWEEN',
						'type'    => 'NUMERIC'
					),
					array(
						'key'     => 'avaibility',
						'value'   => $availability,
						'compare' => '>=',
						'type'    => 'NUMERIC'
					),
					array(
						'key'     => 'start_date',
						'value'   => $date_meta,
						'compare' => '>=',
						'type'    => 'DATE'
					),
				);
			}

			/*TAX WITH DESTINATION ID*/
			if( ! empty( $dest_id ) ){
				$tour_id_related_dest = function_exists( 'fw_get_db_post_option' ) ? fw_get_db_post_option( $dest_id, 'tour_id' ) : array();
				if( ! empty( $tour_id_related_dest ) ){
					$args['post__in'] = $tour_id_related_dest;
				}
			}

			/*TAX WITH CATEGORY ID*/
			if ( ! empty( $cat_id ) ) {
				$args['tax_query'] = array(
					array(
						'taxonomy' => 'ht_tour_cat',
						'field'    => 'term_id',
						'terms'    => $cat_id,
					),
				);
			}

			/*KEYWORDS*/
			if ( ! empty( $kw ) ) {
				if ( ! empty( $post_ids ) ) {
					$args['post__in'] = $post_ids;
				} else {
					unset( $args['post_type'] );
					$args['post_type'] = 'skt_t1_faker';
				}
			}

			// Re-orderby price.
			$attr = [
				'min_price' => $price_min,
				'max_price' => $price_max,
				'orderby'   => $price_order,
			];

			$ids_by_price = goto_get_tour_list( $args, $attr );
			if ( ! empty( $ids_by_price ) ) {
				$args['post__in'] = $ids_by_price;
				$args['orderby']  = 'post__in';
			}
			$q = new WP_Query( $args );

			/*PRINT RESULTS COUNT*/
			$args['fields']         = 'ids';
			$args['posts_per_page'] = -1;
			$get_total              = get_posts( $args );
			/*END PRINT RESULTS COUNT*/

			/*CACHE*/
			ob_start();
				if( $q->have_posts() ):
					goto_tour_list_query( $q, $view_type, $paged );
					$result_count = goto_result_count( $get_total, $per_page, $paged );

					$response['status']       = 200;
					$response['found']        = $q->found_posts;
					$response['count_result'] = $result_count;
					$response['q']            = $kw;
					unset( $response['message'] );
				else:
					$response['status']  = 201;
					$response['message'] = '<p class="no-post-founds">' . esc_html__( 'Sorry, nothing found', 'goto' ) . '</p>';
				endif;
			$response['view_type'] = $view_type;
			$response['content']   = ob_get_clean();
			/*END CACHE*/

			echo json_encode( $response );
			exit();
		}
	}
}



/* INLINE CSS
***************************************************/
add_action( 'wp_enqueue_scripts', 'goto_inline_style', 98 );
function goto_inline_style() {
	$css     = '';
	$id      = get_queried_object_id();
	$page_id = '.page-id-' . $id;

	/*! SINGLE TOUR
	------------------------------------------------->*/
	if( is_singular( 'ht_tour' ) ){
		$style = goto_tour_header();
		if( 'tour-1' == $style ){
			$img_src = get_the_post_thumbnail_url( $id, 'full' );
			$css     .= '.postid-' . $id . ' .tour-cover-image{background-image: url('. esc_url( $img_src ) .')}';
		}
	}

	/*! SINGLE DESTINATION
	------------------------------------------------->*/
	if( is_singular( 'ht_dest' ) && true == get_theme_mod( 'dest_feature_image', false ) ){
		$dest_img_src = get_the_post_thumbnail_url( $id, 'full' );
		$css          .= '.single-ht_dest .page-header{background-image: url('. esc_url( $dest_img_src ) .')}';
	}

	/*! PAGE HEADER SPACE
	------------------------------------------------->*/
	if( true == goto_is_elementor() && true == goto_elementor_page( $id ) ){
		$el_page = \Elementor\Plugin::$instance->documents->get( $id );

		if( 'yes' == $el_page->get_settings( 'page_header' ) ){
			/*HEIGHT*/
			$p_header_height      = $el_page->get_settings( 'page_header_height' );
			$p_header_height_size = $p_header_height['size'];
			$p_header_height_unit = $p_header_height['unit'];
			if( '' !== $p_header_height_size ){
				$css .= $page_id . ' .page-header{height: '. $p_header_height_size . $p_header_height_unit .'}';
			}

			/*SPACE*/
			$p_header_space      = $el_page->get_settings( 'page_header_space' );
			$p_header_space_size = $p_header_space['size'];
			$p_header_space_unit = $p_header_space['unit'];
			if( '' !== $p_header_space_size ){
				$css .= $page_id . ' .page-header{margin-bottom: '. $p_header_space_size . $p_header_space_unit .'}';
			}
		}
	}

	wp_add_inline_style( 'goto-theme-style', $css );
}

/* Support plugin Header Footer Elementor
***************************************************/

// Add a HEADER hook
if ( ! function_exists( 'goto_header' ) ) {
	function goto_header() {
	   do_action( 'goto_header' );
	}
}

add_action( 'goto_header', 'goto_header_markup' );
if ( ! function_exists( 'goto_header_markup' ) ) {
	function goto_header_markup() {
		goto_menu_layout();
	}
}

if ( function_exists( 'hfe_render_header' ) ) {
	// disabled Theme Header
	remove_action( 'goto_header', 'goto_header_markup' );
	// rendering the header from plugin
	add_action( 'goto_header', 'goto_render_hfe_header' );
	function goto_render_hfe_header() {
		hfe_render_header();
	}

}

// Add a FOOTER hook
if ( ! function_exists( 'goto_footer' ) ) {
	function goto_footer() {
	   do_action( 'goto_footer' );
	}
}
 
add_action( 'goto_footer', 'goto_footer_markup' );
if ( ! function_exists( 'goto_footer_markup' ) ) {
	function goto_footer_markup() {
		/*FOOTER WIDGET COLUMN*/
		$column = (int) get_theme_mod( 'ft_column', 4 );

		/*SHOW OR HIDE FOOTER*/
		$show_page_footer = true;
		$page_footer = goto_page_opt( get_queried_object_id(), 'page_footer' );
		if( isset( $page_footer ) && 'yes' != $page_footer ){
			$show_page_footer = false;
		}

		/*FOOTER*/
		if( true == $show_page_footer ):
			?>
				<footer class="theme-footer">
					<?php goto_edit_location( 'footer' );/*EDIT LOCATION*/ ?>
					<div class="container">
						<div class="row">
							<?php
								if( is_active_sidebar( 'footer-widget' ) ):
									echo '<div class="widget-box footer-col-'. esc_attr( $column ) .'">';
										/*CALL TO ACTION*/
										echo '<div class="footer-cta">';
											echo ! empty( get_theme_mod( 'ft_textblock' ) ) ? wp_kses_post( get_theme_mod( 'ft_textblock' ) ) : '';
										echo '</div>';
										/*WIDGET*/
										dynamic_sidebar( 'footer-widget' );
									echo '</div>';
								endif;
							?>
							<div class="footer-copyright">
								<?php /*FOOTER LOGO*/ ?>
								<div class="footer-logo-wr">
									<?php goto_footer_logo(); ?>
								</div>

								<div class="copy-content">
									<?php
										/*NAV MENU*/
										if( has_nav_menu( 'footer' ) ){
											wp_nav_menu( array(
												'theme_location' => 'footer',
												'menu_class'     => 'theme-footer-menu',
												'container'      => ''
											) );
										}

										?>
										<div class="footer-content-copyright">
											<?php
											
											/*COPY RIGHT*/
											if( ! empty( get_theme_mod( 'ft_copy' ) ) ){
												echo do_shortcode( get_theme_mod( 'ft_copy' ) );
											}else{
												echo '<p class="_cp">' . sprintf(
													esc_html__( '&copy; %s Goto. Designed by Haintheme. All rights reserved.', 'goto' ),
													date( 'Y' ) ) . '</p>';
											}
											?>
										</div>
								</div>
								
								<div class="footer-right">
									<?php
										/*RIGHT CONTENT*/
										if( ! empty( get_theme_mod( 'ft_right' ) ) ){
											echo wp_kses_post( get_theme_mod( 'ft_right' ) );
										}
									?>
								</div>
							</div>
						</div>
					</div>
				</footer>
			<?php endif; ?>

			<span id="scroll-to-top" class="ion-ios-arrow-up"></span>
		</div>
		
		<?php
	}
}

if ( function_exists( 'hfe_render_footer' ) ) {
	// disabled Theme Footer
	remove_action( 'goto_footer', 'goto_footer_markup' );
	// rendering the footer from plugin
	add_action( 'goto_footer', 'goto_render_hfe_footer' );
	function goto_render_hfe_footer() {
		hfe_render_footer();
	}
}

// disable the admin notice for unsupported themes
add_action( 'after_setup_theme', 'goto_header_footer_elementor_support' );
if ( ! function_exists( 'goto_header_footer_elementor_support' ) ) {
	function goto_header_footer_elementor_support() {
		add_theme_support( 'header-footer-elementor' );
	}
}

/**
 * Booking form for tour single
 */
if ( ! function_exists( 'goto_booking_form' ) ) {
	function goto_booking_form( $tour_id, $tour_title, $price_unit, $price, $sale_price = null ) {
		?>
		<form class="wpcf7-form booking-form js-booking-form" method="post">
			<div class="booking-form__wrapper">
				<label class="ctf-tour-label" for="booking-date"><?php esc_html_e( 'Pick Up Date', 'goto' ); ?></label>
				<input type="text" name="booking-date" id="booking-date" placeholder="<?php esc_attr_e( '03/22/2019', 'goto' ); ?>" class="tour-date-picker" required>
			</div>
			<div class="booking-form__wrapper">
				<label class="ctf-tour-label" for="booking-quantity"><?php esc_html_e( 'Person(s)', 'goto' ); ?></label>
				<input type="number" name="booking-quantity" id="booking-quantity" min="1" max="99" placeholder="<?php esc_attr_e( '1', 'goto' ); ?>" required>
			</div>
			<input type="hidden" name="booking-id" value="<?php echo esc_attr( $tour_id ); ?>">
			<input type="hidden" name="booking-title" value="<?php echo esc_attr( $tour_title ); ?>">
			<input type="hidden" name="booking-unit" value="<?php echo esc_attr( $price_unit ); ?>">
			<input type="hidden" name="booking-price" value="<?php echo esc_attr( $price ); ?>">
			<input type="hidden" name="booking-sale-price" value="<?php echo esc_attr( $sale_price ); ?>">
			<input type="submit" value="<?php esc_attr_e( 'BOOK THIS TOUR', 'goto' ); ?>" class="wpcf7-form-control wpcf7-submit">
		</form>
		<?php
	}
}

if ( ! function_exists( 'goto_get_currencies' ) ) {
	/**
	 * Get full list of currency codes.
	 *
	 * Currency symbols and names should follow the Unicode CLDR recommendation (http://cldr.unicode.org/translation/currency-names)
	 *
	 * @return array
	 */
	function goto_get_currencies() {
		$currencies = array_unique(
			apply_filters(
				'goto_currencies',
				array(
					'AED' => __( 'United Arab Emirates dirham', 'goto' ),
					'AFN' => __( 'Afghan afghani', 'goto' ),
					'ALL' => __( 'Albanian lek', 'goto' ),
					'AMD' => __( 'Armenian dram', 'goto' ),
					'ANG' => __( 'Netherlands Antillean guilder', 'goto' ),
					'AOA' => __( 'Angolan kwanza', 'goto' ),
					'ARS' => __( 'Argentine peso', 'goto' ),
					'AUD' => __( 'Australian dollar', 'goto' ),
					'AWG' => __( 'Aruban florin', 'goto' ),
					'AZN' => __( 'Azerbaijani manat', 'goto' ),
					'BAM' => __( 'Bosnia and Herzegovina convertible mark', 'goto' ),
					'BBD' => __( 'Barbadian dollar', 'goto' ),
					'BDT' => __( 'Bangladeshi taka', 'goto' ),
					'BGN' => __( 'Bulgarian lev', 'goto' ),
					'BHD' => __( 'Bahraini dinar', 'goto' ),
					'BIF' => __( 'Burundian franc', 'goto' ),
					'BMD' => __( 'Bermudian dollar', 'goto' ),
					'BND' => __( 'Brunei dollar', 'goto' ),
					'BOB' => __( 'Bolivian boliviano', 'goto' ),
					'BRL' => __( 'Brazilian real', 'goto' ),
					'BSD' => __( 'Bahamian dollar', 'goto' ),
					'BTC' => __( 'Bitcoin', 'goto' ),
					'BTN' => __( 'Bhutanese ngultrum', 'goto' ),
					'BWP' => __( 'Botswana pula', 'goto' ),
					'BYR' => __( 'Belarusian ruble (old)', 'goto' ),
					'BYN' => __( 'Belarusian ruble', 'goto' ),
					'BZD' => __( 'Belize dollar', 'goto' ),
					'CAD' => __( 'Canadian dollar', 'goto' ),
					'CDF' => __( 'Congolese franc', 'goto' ),
					'CHF' => __( 'Swiss franc', 'goto' ),
					'CLP' => __( 'Chilean peso', 'goto' ),
					'CNY' => __( 'Chinese yuan', 'goto' ),
					'COP' => __( 'Colombian peso', 'goto' ),
					'CRC' => __( 'Costa Rican col&oacute;n', 'goto' ),
					'CUC' => __( 'Cuban convertible peso', 'goto' ),
					'CUP' => __( 'Cuban peso', 'goto' ),
					'CVE' => __( 'Cape Verdean escudo', 'goto' ),
					'CZK' => __( 'Czech koruna', 'goto' ),
					'DJF' => __( 'Djiboutian franc', 'goto' ),
					'DKK' => __( 'Danish krone', 'goto' ),
					'DOP' => __( 'Dominican peso', 'goto' ),
					'DZD' => __( 'Algerian dinar', 'goto' ),
					'EGP' => __( 'Egyptian pound', 'goto' ),
					'ERN' => __( 'Eritrean nakfa', 'goto' ),
					'ETB' => __( 'Ethiopian birr', 'goto' ),
					'EUR' => __( 'Euro', 'goto' ),
					'FJD' => __( 'Fijian dollar', 'goto' ),
					'FKP' => __( 'Falkland Islands pound', 'goto' ),
					'GBP' => __( 'Pound sterling', 'goto' ),
					'GEL' => __( 'Georgian lari', 'goto' ),
					'GGP' => __( 'Guernsey pound', 'goto' ),
					'GHS' => __( 'Ghana cedi', 'goto' ),
					'GIP' => __( 'Gibraltar pound', 'goto' ),
					'GMD' => __( 'Gambian dalasi', 'goto' ),
					'GNF' => __( 'Guinean franc', 'goto' ),
					'GTQ' => __( 'Guatemalan quetzal', 'goto' ),
					'GYD' => __( 'Guyanese dollar', 'goto' ),
					'HKD' => __( 'Hong Kong dollar', 'goto' ),
					'HNL' => __( 'Honduran lempira', 'goto' ),
					'HRK' => __( 'Croatian kuna', 'goto' ),
					'HTG' => __( 'Haitian gourde', 'goto' ),
					'HUF' => __( 'Hungarian forint', 'goto' ),
					'IDR' => __( 'Indonesian rupiah', 'goto' ),
					'ILS' => __( 'Israeli new shekel', 'goto' ),
					'IMP' => __( 'Manx pound', 'goto' ),
					'INR' => __( 'Indian rupee', 'goto' ),
					'IQD' => __( 'Iraqi dinar', 'goto' ),
					'IRR' => __( 'Iranian rial', 'goto' ),
					'IRT' => __( 'Iranian toman', 'goto' ),
					'ISK' => __( 'Icelandic kr&oacute;na', 'goto' ),
					'JEP' => __( 'Jersey pound', 'goto' ),
					'JMD' => __( 'Jamaican dollar', 'goto' ),
					'JOD' => __( 'Jordanian dinar', 'goto' ),
					'JPY' => __( 'Japanese yen', 'goto' ),
					'KES' => __( 'Kenyan shilling', 'goto' ),
					'KGS' => __( 'Kyrgyzstani som', 'goto' ),
					'KHR' => __( 'Cambodian riel', 'goto' ),
					'KMF' => __( 'Comorian franc', 'goto' ),
					'KPW' => __( 'North Korean won', 'goto' ),
					'KRW' => __( 'South Korean won', 'goto' ),
					'KWD' => __( 'Kuwaiti dinar', 'goto' ),
					'KYD' => __( 'Cayman Islands dollar', 'goto' ),
					'KZT' => __( 'Kazakhstani tenge', 'goto' ),
					'LAK' => __( 'Lao kip', 'goto' ),
					'LBP' => __( 'Lebanese pound', 'goto' ),
					'LKR' => __( 'Sri Lankan rupee', 'goto' ),
					'LRD' => __( 'Liberian dollar', 'goto' ),
					'LSL' => __( 'Lesotho loti', 'goto' ),
					'LYD' => __( 'Libyan dinar', 'goto' ),
					'MAD' => __( 'Moroccan dirham', 'goto' ),
					'MDL' => __( 'Moldovan leu', 'goto' ),
					'MGA' => __( 'Malagasy ariary', 'goto' ),
					'MKD' => __( 'Macedonian denar', 'goto' ),
					'MMK' => __( 'Burmese kyat', 'goto' ),
					'MNT' => __( 'Mongolian t&ouml;gr&ouml;g', 'goto' ),
					'MOP' => __( 'Macanese pataca', 'goto' ),
					'MRU' => __( 'Mauritanian ouguiya', 'goto' ),
					'MUR' => __( 'Mauritian rupee', 'goto' ),
					'MVR' => __( 'Maldivian rufiyaa', 'goto' ),
					'MWK' => __( 'Malawian kwacha', 'goto' ),
					'MXN' => __( 'Mexican peso', 'goto' ),
					'MYR' => __( 'Malaysian ringgit', 'goto' ),
					'MZN' => __( 'Mozambican metical', 'goto' ),
					'NAD' => __( 'Namibian dollar', 'goto' ),
					'NGN' => __( 'Nigerian naira', 'goto' ),
					'NIO' => __( 'Nicaraguan c&oacute;rdoba', 'goto' ),
					'NOK' => __( 'Norwegian krone', 'goto' ),
					'NPR' => __( 'Nepalese rupee', 'goto' ),
					'NZD' => __( 'New Zealand dollar', 'goto' ),
					'OMR' => __( 'Omani rial', 'goto' ),
					'PAB' => __( 'Panamanian balboa', 'goto' ),
					'PEN' => __( 'Sol', 'goto' ),
					'PGK' => __( 'Papua New Guinean kina', 'goto' ),
					'PHP' => __( 'Philippine peso', 'goto' ),
					'PKR' => __( 'Pakistani rupee', 'goto' ),
					'PLN' => __( 'Polish z&#x142;oty', 'goto' ),
					'PRB' => __( 'Transnistrian ruble', 'goto' ),
					'PYG' => __( 'Paraguayan guaran&iacute;', 'goto' ),
					'QAR' => __( 'Qatari riyal', 'goto' ),
					'RON' => __( 'Romanian leu', 'goto' ),
					'RSD' => __( 'Serbian dinar', 'goto' ),
					'RUB' => __( 'Russian ruble', 'goto' ),
					'RWF' => __( 'Rwandan franc', 'goto' ),
					'SAR' => __( 'Saudi riyal', 'goto' ),
					'SBD' => __( 'Solomon Islands dollar', 'goto' ),
					'SCR' => __( 'Seychellois rupee', 'goto' ),
					'SDG' => __( 'Sudanese pound', 'goto' ),
					'SEK' => __( 'Swedish krona', 'goto' ),
					'SGD' => __( 'Singapore dollar', 'goto' ),
					'SHP' => __( 'Saint Helena pound', 'goto' ),
					'SLL' => __( 'Sierra Leonean leone', 'goto' ),
					'SOS' => __( 'Somali shilling', 'goto' ),
					'SRD' => __( 'Surinamese dollar', 'goto' ),
					'SSP' => __( 'South Sudanese pound', 'goto' ),
					'STN' => __( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe dobra', 'goto' ),
					'SYP' => __( 'Syrian pound', 'goto' ),
					'SZL' => __( 'Swazi lilangeni', 'goto' ),
					'THB' => __( 'Thai baht', 'goto' ),
					'TJS' => __( 'Tajikistani somoni', 'goto' ),
					'TMT' => __( 'Turkmenistan manat', 'goto' ),
					'TND' => __( 'Tunisian dinar', 'goto' ),
					'TOP' => __( 'Tongan pa&#x2bb;anga', 'goto' ),
					'TRY' => __( 'Turkish lira', 'goto' ),
					'TTD' => __( 'Trinidad and Tobago dollar', 'goto' ),
					'TWD' => __( 'New Taiwan dollar', 'goto' ),
					'TZS' => __( 'Tanzanian shilling', 'goto' ),
					'UAH' => __( 'Ukrainian hryvnia', 'goto' ),
					'UGX' => __( 'Ugandan shilling', 'goto' ),
					'USD' => __( 'United States (US) dollar', 'goto' ),
					'UYU' => __( 'Uruguayan peso', 'goto' ),
					'UZS' => __( 'Uzbekistani som', 'goto' ),
					'VEF' => __( 'Venezuelan bol&iacute;var', 'goto' ),
					'VES' => __( 'Bol&iacute;var soberano', 'goto' ),
					'VND' => __( 'Vietnamese &#x111;&#x1ed3;ng', 'goto' ),
					'VUV' => __( 'Vanuatu vatu', 'goto' ),
					'WST' => __( 'Samoan t&#x101;l&#x101;', 'goto' ),
					'XAF' => __( 'Central African CFA franc', 'goto' ),
					'XCD' => __( 'East Caribbean dollar', 'goto' ),
					'XOF' => __( 'West African CFA franc', 'goto' ),
					'XPF' => __( 'CFP franc', 'goto' ),
					'YER' => __( 'Yemeni rial', 'goto' ),
					'ZAR' => __( 'South African rand', 'goto' ),
					'ZMW' => __( 'Zambian kwacha', 'goto' ),
				)
			)
		);

		return $currencies;
	}
}

if ( ! function_exists( 'goto_get_currency_symbols' ) ) {
	/**
	 * Get all available Currency symbols.
	 *
	 * Currency symbols and names should follow the Unicode CLDR recommendation (http://cldr.unicode.org/translation/currency-names)
	 *
	 * @since 4.1.0
	 * @return array
	 */
	function goto_get_currency_symbols() {
		$symbols = apply_filters(
			'goto_currency_symbols',
			array(
				'AED' => '&#x62f;.&#x625;',
				'AFN' => '&#x60b;',
				'ALL' => 'L',
				'AMD' => 'AMD',
				'ANG' => '&fnof;',
				'AOA' => 'Kz',
				'ARS' => '&#36;',
				'AUD' => '&#36;',
				'AWG' => 'Afl.',
				'AZN' => 'AZN',
				'BAM' => 'KM',
				'BBD' => '&#36;',
				'BDT' => '&#2547;&nbsp;',
				'BGN' => '&#1083;&#1074;.',
				'BHD' => '.&#x62f;.&#x628;',
				'BIF' => 'Fr',
				'BMD' => '&#36;',
				'BND' => '&#36;',
				'BOB' => 'Bs.',
				'BRL' => '&#82;&#36;',
				'BSD' => '&#36;',
				'BTC' => '&#3647;',
				'BTN' => 'Nu.',
				'BWP' => 'P',
				'BYR' => 'Br',
				'BYN' => 'Br',
				'BZD' => '&#36;',
				'CAD' => '&#36;',
				'CDF' => 'Fr',
				'CHF' => '&#67;&#72;&#70;',
				'CLP' => '&#36;',
				'CNY' => '&yen;',
				'COP' => '&#36;',
				'CRC' => '&#x20a1;',
				'CUC' => '&#36;',
				'CUP' => '&#36;',
				'CVE' => '&#36;',
				'CZK' => '&#75;&#269;',
				'DJF' => 'Fr',
				'DKK' => 'DKK',
				'DOP' => 'RD&#36;',
				'DZD' => '&#x62f;.&#x62c;',
				'EGP' => 'EGP',
				'ERN' => 'Nfk',
				'ETB' => 'Br',
				'EUR' => '&euro;',
				'FJD' => '&#36;',
				'FKP' => '&pound;',
				'GBP' => '&pound;',
				'GEL' => '&#x20be;',
				'GGP' => '&pound;',
				'GHS' => '&#x20b5;',
				'GIP' => '&pound;',
				'GMD' => 'D',
				'GNF' => 'Fr',
				'GTQ' => 'Q',
				'GYD' => '&#36;',
				'HKD' => '&#36;',
				'HNL' => 'L',
				'HRK' => 'kn',
				'HTG' => 'G',
				'HUF' => '&#70;&#116;',
				'IDR' => 'Rp',
				'ILS' => '&#8362;',
				'IMP' => '&pound;',
				'INR' => '&#8377;',
				'IQD' => '&#x639;.&#x62f;',
				'IRR' => '&#xfdfc;',
				'IRT' => '&#x062A;&#x0648;&#x0645;&#x0627;&#x0646;',
				'ISK' => 'kr.',
				'JEP' => '&pound;',
				'JMD' => '&#36;',
				'JOD' => '&#x62f;.&#x627;',
				'JPY' => '&yen;',
				'KES' => 'KSh',
				'KGS' => '&#x441;&#x43e;&#x43c;',
				'KHR' => '&#x17db;',
				'KMF' => 'Fr',
				'KPW' => '&#x20a9;',
				'KRW' => '&#8361;',
				'KWD' => '&#x62f;.&#x643;',
				'KYD' => '&#36;',
				'KZT' => '&#8376;',
				'LAK' => '&#8365;',
				'LBP' => '&#x644;.&#x644;',
				'LKR' => '&#xdbb;&#xdd4;',
				'LRD' => '&#36;',
				'LSL' => 'L',
				'LYD' => '&#x644;.&#x62f;',
				'MAD' => '&#x62f;.&#x645;.',
				'MDL' => 'MDL',
				'MGA' => 'Ar',
				'MKD' => '&#x434;&#x435;&#x43d;',
				'MMK' => 'Ks',
				'MNT' => '&#x20ae;',
				'MOP' => 'P',
				'MRU' => 'UM',
				'MUR' => '&#x20a8;',
				'MVR' => '.&#x783;',
				'MWK' => 'MK',
				'MXN' => '&#36;',
				'MYR' => '&#82;&#77;',
				'MZN' => 'MT',
				'NAD' => 'N&#36;',
				'NGN' => '&#8358;',
				'NIO' => 'C&#36;',
				'NOK' => '&#107;&#114;',
				'NPR' => '&#8360;',
				'NZD' => '&#36;',
				'OMR' => '&#x631;.&#x639;.',
				'PAB' => 'B/.',
				'PEN' => 'S/',
				'PGK' => 'K',
				'PHP' => '&#8369;',
				'PKR' => '&#8360;',
				'PLN' => '&#122;&#322;',
				'PRB' => '&#x440;.',
				'PYG' => '&#8370;',
				'QAR' => '&#x631;.&#x642;',
				'RMB' => '&yen;',
				'RON' => 'lei',
				'RSD' => '&#1088;&#1089;&#1076;',
				'RUB' => '&#8381;',
				'RWF' => 'Fr',
				'SAR' => '&#x631;.&#x633;',
				'SBD' => '&#36;',
				'SCR' => '&#x20a8;',
				'SDG' => '&#x62c;.&#x633;.',
				'SEK' => '&#107;&#114;',
				'SGD' => '&#36;',
				'SHP' => '&pound;',
				'SLL' => 'Le',
				'SOS' => 'Sh',
				'SRD' => '&#36;',
				'SSP' => '&pound;',
				'STN' => 'Db',
				'SYP' => '&#x644;.&#x633;',
				'SZL' => 'L',
				'THB' => '&#3647;',
				'TJS' => '&#x405;&#x41c;',
				'TMT' => 'm',
				'TND' => '&#x62f;.&#x62a;',
				'TOP' => 'T&#36;',
				'TRY' => '&#8378;',
				'TTD' => '&#36;',
				'TWD' => '&#78;&#84;&#36;',
				'TZS' => 'Sh',
				'UAH' => '&#8372;',
				'UGX' => 'UGX',
				'USD' => '&#36;',
				'UYU' => '&#36;',
				'UZS' => 'UZS',
				'VEF' => 'Bs F',
				'VES' => 'Bs.S',
				'VND' => '&#8363;',
				'VUV' => 'Vt',
				'WST' => 'T',
				'XAF' => 'CFA',
				'XCD' => '&#36;',
				'XOF' => 'CFA',
				'XPF' => 'Fr',
				'YER' => '&#xfdfc;',
				'ZAR' => '&#82;',
				'ZMW' => 'ZK',
			)
		);

		return $symbols;
	}
}

if ( ! function_exists( 'goto_unit' ) ) {
	/**
	 * Get Currency symbol
	 * @param  string $unit The price unit symbol.
	 */
	function goto_unit( $unit ) {
		$symbols = goto_get_currency_symbols();
		return isset( $symbols[ $unit ] ) ? $symbols[ $unit ] : '';
	}
}

if ( ! function_exists( 'goto_price_unit' ) ) {
	/**
	 * Echo price with symbol left or right
	 * @param  string  $symbol_post The symbol character.
	 * @param  string  $unit        The unit price.
	 * @param  string  $price       The price.
	 * @param  boolean $echo        Echo.
	 */
	function goto_price_unit( $symbol_post, $unit, $price, $echo = true ) {
		$comma_decimal  = apply_filters( 'goto_price_unit_decimal_separator', ',' );
		$comma_thousand = apply_filters( 'goto_price_unit_thousand_separator', ',' );
		$html           = number_format( (float) $price, 0, $comma_decimal, $comma_thousand ) . $unit;
		if ( 'left' === $symbol_post ) {
			$html = $unit . number_format( (float) $price, 0, $comma_decimal, $comma_thousand );
		}

		if ( $echo ) {
			echo esc_html( $html );
		} else {
			return $html;
		}
	}
}
